from itertools import *

#------------------------------------------
word = 'КУКАРЕКУ'
known = {'Е': '100', 'Л': '011'}
add = 'КУАР'
#------------------------------------------

def phanoOK( code, known ):
  return all( not c.startswith(code) and not code.startswith(c)
              for c in known.values() )

lenAdd = len(add)
maxL = 4
allCodes = [ ''.join(w) for i in range(1,maxL+1)
             for w in product('01', repeat=i) ]

N = len(allCodes)
minLen = float('inf')
for idx in permutations(range(N), lenAdd):
  curCodes = known.copy()
  for k, i in enumerate(idx):
    if not phanoOK( allCodes[i], curCodes ): break
    curCodes[add[k]] = allCodes[i]
  else:
    curLen = sum( len(curCodes[c]) for c in word )
    if curLen < minLen:
      minLen = curLen
      best = curCodes.copy()

print( minLen, best )