#4.193_solve

from itertools import permutations

pool = [ [ '10', '000', '001', '010'], #список из возможных комбинаций кодов
         [ '00', '10', '0100', '0101'],
         [ '000', '001', '010', '10'],
           ]

known = { 'К': '011', 'Р': '11' } #словарь с известным соответствием символ-код
perm = list( permutations([0, 1, 2, 3]) ) #создает список из всех возможных перестановок
                                          #из символов 0, 1, 2, 3
                                          #т.е. [(0,1,2,3),(0,1,3,2),(0,2,1,3),(0,2,3,1)...]

def encode( word, dic ): #функция шифрования слова word по словарю символов dic
  return ''.join( [ dic[c] for c in word ] )  #для каждого символа в слове word возвращается
                                              #его значение в словаре (ключом является
                                              #сам символ)
                                              #[ dic[c] for c in word ] возвращает массив
                                              #зашифрованных строк (каждая строка - отдельный
                                              #символ из word)
                                              #''.join([]) сливает все строки в одну,
                                              #результат - защифрованная строка

minLen = 100 #размер текущей минимальной кодирующей строки, изначально больше
             #чем любая из возможных кодирующих (чтобы хоть одна, но подошла)
for a, b, c, d in perm: #цикл для каждой из возможных перестановок, в переменных сохраняются
                        #значений 0,1,2,3 в соответствующем порядке
  for p in pool: #цикл для каждой из возможных комбинаций кодов
    add = { 'П': p[a], 'Л': p[b], 'Е': p[c], 'С': p[d] } #в словарь add добавляются
                                                         #недостающие буквы, им присваиваются
                                                         #коды для текущей комбинации кодов
                                                         #в случайной перестановке
                                                         #использование двух циклов for
                                                         #обеспечивает проверку всех
                                                         #возможных комбинаций шифров для
                                                         #каждой из букв
    full = known | add  #объединение в один словарь словаря известных символов и
                        #сгенерированного словаря для недостающих символов
    coded = encode( 'ПЕРЕПЕЛ', full ) #кодирование по общему словарю шифров слова ПЕРЕПЕЛ
    if len(coded) <= minLen: #в случае если длина полученного кода меньше минимальной,
                             #в переменную minLen сохраняется новая минимальная длина 
                             #и в консоль выводится форматированная строка результата:
                             #закодированная строка, строка приведенная к целому значению
                             #по основанию 2, после этого выводящщаяся в восьмиричном формате
                             #(о) и словарь кодов
      minLen = len(coded)
      print( coded, f"{int(coded,2):o}", full )
'''
Результат:
100011100110001000 434610 {'К': '011', 'Р': '11', 'П': '10', 'Л': '000', 'Е': '001', 'С': '010'}
100101101010010000 455220 {'К': '011', 'Р': '11', 'П': '10', 'Л': '000', 'Е': '010', 'С': '001'}
00010111000010001 27021 {'К': '011', 'Р': '11', 'П': '000', 'Л': '001', 'Е': '10', 'С': '010'}
0010111000100100 27044 {'К': '011', 'Р': '11', 'П': '00', 'Л': '0100', 'Е': '10', 'С': '0101'}
0010111000100101 27045 {'К': '011', 'Р': '11', 'П': '00', 'Л': '0101', 'Е': '10', 'С': '0100'}
1000110010000100 106204 {'К': '011', 'Р': '11', 'П': '10', 'Л': '0100', 'Е': '00', 'С': '0101'}
1000110010000101 106205 {'К': '011', 'Р': '11', 'П': '10', 'Л': '0101', 'Е': '00', 'С': '0100'}
'''
