STOP = 999
#-------------------------------------------
# Машина Тьюринга
# s - исходная строка
# prog - программа в виде словаря
#-------------------------------------------
q0, q1, q2 = 0, 1, 2
L, N, R = -1, 0, 1
def MT( s, prog, startPos = -1 ):
  s = list(' ' + s + ' ')
  pos = (len(s) + startPos) % len(s)
  state = 0
  while state != STOP:
    cmd = prog[ (s[pos], state) ]
    s[pos] = cmd[0]
    pos += cmd[1]
    state = cmd[2]
  return ''.join(s)

#-------------------------------------------
# Программа для Машины Тьюринга
# Словарь
# (символ, состояние): (новый символ, сдвиг каретки, новое состояние)
#-------------------------------------------
prog = {
  (' ', q0): (' ', L, q1),
  (' ', q1): ('1', 0, STOP),

  ('1', q1): ('0', L, q1),
  ('3', q1): ('1', L, q1),
  ('4', q1): ('2', L, q1),
  }

#-------------------------------------------
# Основная программа
#-------------------------------------------
s = '4'*599 + '3' + '1'*399
sNew = MT( s, prog )
print( f"'{sNew}'" )
print( sum(map(int, sNew[:-1])) )
print( len(s), sum(map(int, s)) )
