STOP = 999
#-------------------------------------------
# Машина Тьюринга
# s - исходная строка
# prog - программа в виде словаря
#-------------------------------------------
def MT( s, prog ):
  s = list(' ' + s + ' ')
  pos = len(s) - 1
  state = 0
  while state != STOP:
    cmd = prog[ (s[pos], state) ]
    s[pos] = cmd[0]
    pos += cmd[1]
    state = cmd[2]
  return ''.join(s)

#-------------------------------------------
# Программа для Машины Тьюринга
# Словарь
# (символ, состояние): (новый символ, сдвиг каретки, новое состояние)
#-------------------------------------------
L, R = -1, 1
prog = {
  (' ', 0): (' ', L, 1),
  (' ', 1): (' ', 0, STOP),
  ('0', 1): ('1', L, 1),
  ('1', 1): ('0', L, 1),
  }

#-------------------------------------------
# Основная программа
#-------------------------------------------
s = f'{135:b}'
sNew = MT( s, prog )
print( int(sNew, 2) )
