STOP = 999
#-------------------------------------------
# Машина Тьюринга
# s - исходная строка
# prog - программа в виде словаря
#-------------------------------------------
def MT( s, prog ):
  s = list(' ' + s + ' ')
  pos = len(s) - 1
  state = 0
  while state != STOP:
    cmd = prog[ (s[pos], state) ]
    s[pos] = cmd[0]
    pos += cmd[1]
    state = cmd[2]
  return ''.join(s)

#-------------------------------------------
# Программа для Машины Тьюринга
# Словарь
# (символ, состояние): (новый символ, сдвиг каретки, новое состояние)
#-------------------------------------------
prog = {
  (' ', 0): (' ', -1, 1),
  (' ', 1): (' ', 0, STOP),
  ('0', 1): ('3', -1, 1),
  ('1', 1): ('1', -1, 1),
  ('3', 1): ('0', -1, 1),
}

#-------------------------------------------
# Основная программа
#-------------------------------------------
s = '1'*100 + '3'*900
sNew = MT( s, prog )
print( f"0: {sNew.count('0')}   1: {sNew.count('1')}")
print( sNew )
