#-------------------------------------------
# Машина Тьюринга
# s - исходная строка
# prog - программа в виде словаря
#-------------------------------------------
STOP = 999
q0, q1, q2 = 0, 1, 2
L, N, R = -1, 0, 1
def MT( s, prog, startPos = -1 ):
  s = list(' ' + s + ' ')
  pos = (len(s) + startPos) % len(s)
  state = 0
  while state != STOP:
    cmd = prog[ (s[pos], state) ]
    s[pos] = cmd[0]
    pos += cmd[1]
    state = cmd[2]
  return ''.join(s)

#-------------------------------------------
# Программа для Машины Тьюринга
# Словарь
# (символ, состояние): (новый символ, сдвиг каретки, новое состояние)
#-------------------------------------------
prog = {
  (' ', q0): (' ', L, q1),
  (' ', q1): (' ', 0, STOP),

  ('0', q1): ('1', 0, STOP),

  ('1', q1): ('0', L, q1),
  }

#-------------------------------------------
# Основная программа
#-------------------------------------------
for n in range(0,1000):
  s = ['1']*1000
  s[n] = '0'
  s = ''.join(s)
  sNew = MT( s, prog )[1:]
  if sNew.count('0') == 758:
    print( n )
