def firstPrimes( n ):
  primes = [2]
  k = 3
  while len(primes) < n:
    divs = [int(k % d == 0)  for d in primes]
    if sum(divs) == 0:
      primes.append( k )
    k += 1
  return primes

def factorize(x):
  primeDels = []
  k = 2
  while x > 1:
    while x % k == 0:
      primeDels.append(k)
      x /= k
    k += 1
  return primeDels

primeFactors = factorize(512)
primeFactors.reverse()
primes = firstPrimes(len(primeFactors))
N = 1
for i in range(len(primeFactors)):
  N *= primes[i]**(primeFactors[i]-1)

for i, p in enumerate(primes):
  k = primeFactors[i]
  lastPrime = primes[-1]
  kLast = primeFactors[-1]
  while p**((kLast-1)*k) < lastPrime**(kLast-1):
    N = N // lastPrime**(kLast-1) * p**((kLast-1)*k)
    k *= kLast
    primeFactors[i] = k
    del primes[-1]
    del primeFactors[-1]
    lastPrime = primes[-1]
    kLast = primeFactors[-1]
    print( N, primes, primeFactors )

if N < 2**31:
  print( N, primes[-1] )
else:
  print('NO')


