"""
Входной файл содержит сведения о заявках на проведение занятий в конференц-зале.
В каждой заявке указаны время начала и время окончания мероприятия (в минутах от начала
суток), а также сумма, которую компания-организатор готова заплатить за аренду зала.
Если время проведения двух или более мероприятий пересекается, то провести
можно не более одного из них. Определите максимальную выручку, которую можно
получить за аренду в течение суток, а также суммарное время проводимых мероприятий.
Входные данные представлены в файле следующим образом. В первой строке
входного файла находится натуральное число N (1 ≤ N ≤ 1000) – количество заявок
на проведение мероприятий. Каждая из следующих N строк содержит три числа:
время начала и время окончания мероприятия (натуральные числа, не превосходящее 1440),
а также сумма оплаты за аренду (натуральное число).
Запишите в ответе два числа: максимальную выручку, которую можно
получить за аренду в течение суток, и суммарное время проводимых мероприятий.
"""
with open("26-160.txt") as F:
   data = []
   N = int(F.readline())
   for i in range(N):
     t0, t1, cost = map(int, F.readline().split())
     data.append( (t0, t1, cost) )

data.sort( key = lambda x: x[1] )

dp = [ data[i][2] for i in range(N) ]

for i in range(1,N):
  dp[i] = data[i][2] + max( (dp[j] for j in range(i)
                             if data[j][1] < data[i][0]), default= 0 )
maxTotalCost = max(dp)

count = 0
totalTime = 0
R = maxTotalCost
i = dp.index(maxTotalCost)
while True:
  totalTime += data[i][1] - data[i][0] + 1
  count += 1
  R -= data[i][2]
  if not R: break
  indices = [ k for k in range(i)
              if dp[k] == R and dp[k] + data[i][2] == dp[i] and
                 data[k][1] < data[i][0] ]
  #if len(indices) > 1:
  #  print( indices )
  i = indices[0]

print( maxTotalCost, totalTime, count )







