def interpret( s ):
  s = s.replace('[', ' [ ').replace(']', ' ] ')
  terms = s.split()
  nest = 0
  prog = "import turtle\nt = turtle.Turtle()\nt.speed(0)\n"
  for t, tNext in zip(terms, terms[1:]):
    if t == '[': nest += 1
    elif t == ']': nest -= 1
    elif t == "Повтори":
      n = int(tNext)
      prog += '  '*nest + f"for {'_'*(nest+1)} in range({n}):\n"
    elif t == "Вперёд":
      n = int(tNext)
      prog += '  '*nest + f"t.fd({n})\n"
    elif t == "Назад":
      n = int(tNext)
      prog += '  '*nest + f"t.bd({n})\n"
    elif t == "Направо":
      n = int(tNext)
      prog += '  '*nest + f"t.rt({n})\n"
    elif t == "Налево":
      n = int(tNext)
      prog += '  '*nest + f"t.lt({n})\n"
    elif t == "Опустить" and tNext == "хвост":
      prog += '  '*nest + "t.pendown()\n"
    elif t == "Поднять" and tNext == "хвост":
      prog += '  '*nest + "t.penup()\n"
  prog += 'turtle.done()'
  return prog

if __name__ == "__main__":
    s = """Направо 180
    Повтори 9 [Вперёд 59 Налево 90 Вперёд 84 Налево 90]
    Поднять хвост
    Вперёд 18 Налево 90 Вперёд 38 Направо 90
    Опустить хвост
    Повтори 9 [Вперёд 120 Направо 90 Вперёд 99 Направо 90]"""
    prog = interpret(s)
    print( prog )
    exec( prog )