K = 3  # количество кластеров

def findClusterNo( x, y ):
  return -1 if y < -10 or y > 30 else \
          0 if x > 18 else \
          1 if y > 20 else \
          2

#------------------------------------------------

clusters = [ [] for i in range(K) ]

for s in open("27-102b.txt"):
    x, y = s.replace(',','.').split()
    x, y = float(x), float(y)
    clusterNo = findClusterNo( x, y )
    if clusterNo >= 0:
      clusters[clusterNo].append( (x, y) )

clusters.sort( key=lambda cls: len(cls) )
print( [len(cls) for cls in clusters] )

from math import dist

acenters = []
for k in range(K):
  minSumDist = float('-inf')
  for pAcenter in clusters[k]:
    sumDist = sum( dist(pAcenter,p)
                   for p in clusters[k] )
    if sumDist > minSumDist:
      minSumDist = sumDist
      acenter = pAcenter
  acenters.append( acenter )

print( "Центры:\n", acenters )

acenters.sort( key = lambda x: dist(x,(0,0)) )

Q1 = acenters[-1][0]
Q2 = acenters[0][1]

print( int(abs(Q1)*10_000), int(abs(Q2)*10_000) )

