STOP = 999
#-------------------------------------------
# Машина Тьюринга
# s - исходная строка
# prog - программа в виде словаря
#-------------------------------------------
q0, q1, q2 = 0, 1, 2
L, N, R = -1, 0, 1
def MT( s, prog, startPos = -1 ):
  s = list(' ' + s + ' ')
  pos = (len(s) + startPos) % len(s)
  state = 0
  while state != STOP:
    cmd = prog[ (s[pos], state) ]
    s[pos] = cmd[0]
    pos += cmd[1]
    state = cmd[2]
  return ''.join(s)

#-------------------------------------------
# Программа для Машины Тьюринга
# Словарь
# (символ, состояние): (новый символ, сдвиг каретки, новое состояние)
#-------------------------------------------
prog = {
  (' ', q0): (' ', L, q1),
  (' ', q1): (' ', 0, STOP),

  ('0', q1): ('1', L, q1),
  ('1', q1): ('0', L, q1),
  }

#-------------------------------------------
# Основная программа
#-------------------------------------------
X = sum(range(1,100))
res = f"{X:b}"
s = res.replace('0','.').replace('1','0').replace('.','1')
while True:
  s = '1' + s
  N = int(s, 2)
  if N > 99999: break
  if N >= 1000: print( N )
  sNew = MT( s, prog )

print( f"'{sNew}'" )
print( int(sNew,2) == X )
