STOP = 999
#-------------------------------------------
# Машина Тьюринга
# s - исходная строка
# prog - программа в виде словаря
#-------------------------------------------
q0, q1, q2 = 0, 1, 2
L, N, R = -1, 0, 1
def MT( s, prog, startPos = -1 ):
  s = list(' ' + s + ' ')
  pos = (len(s) + startPos) % len(s)
  state = 0
  while state != STOP:
    cmd = prog[ (s[pos], state) ]
    s[pos] = cmd[0]
    pos += cmd[1]
    state = cmd[2]
  return ''.join(s)

#-------------------------------------------
# Программа для Машины Тьюринга
# Словарь
# (символ, состояние): (новый символ, сдвиг каретки, новое состояние)
#-------------------------------------------
prog = {
  (' ', q0): ('0', R, q1),
  (' ', q1): ('1', R, q0),
  (' ', q2): (' ', 0, STOP),

  ('0', q0): ('0', N, q2),
  ('0', q1): ('0', N, q2),
  ('0', q2): ('1', R, q2),

  ('1', q0): ('1', N, q2),
  ('1', q1): ('1', N, q2),
  ('1', q2): ('0', R, q2),
  }

#-------------------------------------------
# Основная программа
#-------------------------------------------
for n in range(1,1000):
  for k in range(100):
    s = ' '*k + f'{n:b}'
    sNew = MT( s, prog, 0 )[1:]
    val = int(sNew, 2)
    if val == 2684:
      print( n, val, sNew )
