STOP = 999
#-------------------------------------------
# Машина Тьюринга
# s - исходная строка
# prog - программа в виде словаря
#-------------------------------------------
q0, q1, q2 = 0, 1, 2
L, N, R = -1, 0, 1
def MT( s, prog, startPos = -1 ):
  s = list(' ' + s + ' ')
  pos = (len(s) + startPos) % len(s)
  state = 0
  while state != STOP:
    cmd = prog[ (s[pos], state) ]
    s[pos] = cmd[0]
    pos += cmd[1]
    state = cmd[2]
  return ''.join(s)

#-------------------------------------------
# Программа для Машины Тьюринга
# Словарь
# (символ, состояние): (новый символ, сдвиг каретки, новое состояние)
#-------------------------------------------
prog = {
  (' ', q0): ('0', L, q1),
  (' ', q1): ('1', L, q0),
  (' ', q2): ('1', 0, STOP),

  ('0', q0): ('0', N, q2),
  ('0', q1): ('0', N, q2),
  ('0', q2): ('1', L, q2),

  ('1', q0): ('1', N, q2),
  ('1', q1): ('1', N, q2),
  ('1', q2): ('0', L, q2),
  }

#-------------------------------------------
# Основная программа
#-------------------------------------------
for n in range(10):
  s = f'{10:b}' + ' '*n
  sNew = MT( s, prog )
  val = int(sNew, 2)
  if val == 682:
    print( n+1, '"'+s+'"', val )
    break
