STOP = 999
#-------------------------------------------
# Машина Тьюринга
# s - исходная строка
# prog - программа в виде словаря
#-------------------------------------------
def MT( s, prog, startPos = -1 ):
  s = list(' ' + s + ' ')
  pos = (len(s) + startPos) % len(s)
  state = 0
  while state != STOP:
    cmd = prog[ (s[pos], state) ]
    s[pos] = cmd[0]
    pos += cmd[1]
    state = cmd[2]
  return ''.join(s)

#-------------------------------------------
# Программа для Машины Тьюринга
# Словарь
# (символ, состояние): (новый символ, сдвиг каретки, новое состояние)
#-------------------------------------------
L, R = -1, 1
prog = {
  (' ', 0): (' ', L, 1),
  (' ', 1): (' ', 0, STOP),
  ('0', 1): ('1', L, 1),
  ('1', 1): ('0', L, 1),
  }

#-------------------------------------------
# Основная программа
#-------------------------------------------
for n in range(50000, 0, -1):
  s = f'{n:b}'
  sNew = MT( s, prog )[1:]
  val = int(sNew, 2)
  if val == 218:
    print( n, s, val )
    break
