STOP = 999
#-------------------------------------------
# Машина Тьюринга
# s - исходная строка
# prog - программа в виде словаря
#-------------------------------------------
def MT( s, prog, startPos = -1 ):
  s = list(' ' + s + ' ')
  pos = (len(s) + startPos) % len(s)
  state = 0
  while state != STOP:
    cmd = prog[ (s[pos], state) ]
    s[pos] = cmd[0]
    pos += cmd[1]
    state = cmd[2]
  return ''.join(s)

#-------------------------------------------
# Программа для Машины Тьюринга
# Словарь
# (символ, состояние): (новый символ, сдвиг каретки, новое состояние)
#-------------------------------------------
q0, q1, q2, q3 = 0, 1, 2, 3
L, R = -1, 1
prog = {
  (' ', q0): (' ', L, q1),
  (' ', q1): (' ', 0, STOP),
  (' ', q2): (' ', 0, STOP),
  (' ', q3): (' ', 0, STOP),

  ('0', q1): ('1', L, q2),
  ('0', q2): ('1', L, q3),
  ('0', q3): ('0', L, q2),

  ('1', q1): ('0', L, q2),
  ('1', q2): ('0', L, q2),
  ('1', q3): ('1', L, q3),
  }

#-------------------------------------------
# Основная программа
#-------------------------------------------
s = f'{204:b}'
sNew = MT( s, prog )
print( int(sNew, 2) )
