'''
12_262  Автор: Б.С. Михлин
...
ПОКА нашлось(01) ИЛИ нашлось(02) ИЛИ нашлось(03)
  заменить(01, 2302)
  заменить(02, 10)
  заменить(03, 201)
КОНЕЦ ПОКА
Известно, что исходная строка начиналась с нуля, а далее содержала только единицы, двойки и тройки.
После выполнения данной программы получилась строка, содержащая 60 единиц, 22 двойки и 17 троек.
Сколько единиц было в исходной строке?

Решение
Порядок следования цифр 1, 2, 3 в исходной строке не имеет значения (не влияет на суммарное количество единиц,
двоек и троек в результирующей строке), т.к. комбинации 01, 02 и 03 преобразуются в комбинации,
оканчивающиеся нулем (все комбинации передают ноль для следующей в исходной строке цифры):
01... - 2302... - 2310...
02 - 10...
03... - 201... - 22310...
Поэтому исходную строку "s" можно  формировать, как ноль, блок единиц, блок двоек и блок троек.
Далее используем переборное решение.
При параметре в range больше 50 будет задержка в выполнении программы из-за вложенных циклов.
'''
for k1 in range(50):
    for k2 in range(50):
        for k3 in range(50):
            s = '0' + k1 * '1' + k2 * '2' + k3 * '3'
            while ('01' in s) or ('02' in s) or ('03' in s):
                s = s.replace('01', '2302', 1)
                s = s.replace('02', '10', 1)
                s = s.replace('03', '201', 1)
            if s.count('1') == 60 and s.count('2') == 22 and s.count('3') == 17:
                print(k1)  # Ответ: 12
                #print(k2, k3)  # отладочная 43 5
                exit()