
K = 5  # количество кластеров

def findClusterNo( x, y ):
  return  0 if x > 8 and y > 0 else \
          1 if x > 8 and y < 0 else \
          2 if x > -5 else \
          3 if y > 5 else \
          4

#------------------------------------------------

clusters = [ [] for i in range(K) ]

for s in open("27-99b.txt"):
    x, y = s.replace(',','.').split()
    x, y = float(x), float(y)
    clusterNo = findClusterNo( x, y )
    if clusterNo >= 0:
      clusters[clusterNo].append( (x, y) )


from turtle import *
tracer(0); penup(); hideturtle()
colors = ["red", "green", "blue", "magenta", "cyan"]
scale, shiftX, shiftY = 10, 0, 50
for k, cluster in enumerate(clusters):
  for x, y in cluster:
    goto( x*scale-shiftX, y*scale-shiftY )
    dot( 3, colors[k] )
done()

from math import dist

centers = []
for k in range(K):
  minSumDist = float('inf')
  for pCenter in clusters[k]:
    sumDist = sum( dist(pCenter,p)
                   for p in clusters[k] )
    if sumDist < minSumDist:
      minSumDist = sumDist
      center = pCenter
  centers.append( center )

print( "Центры:\n", centers )

Mx = sum( c[0] for c in centers ) / K
My = sum( c[1] for c in centers ) / K

dists = [ dist(c, (Mx, My)) for c in centers ]
minDist = min(dists)
maxDist = max(dists)

kMin = dists.index(minDist)
kMax = dists.index(maxDist)

print( len(clusters[kMin]), len(clusters[kMax]) )

