from itertools import product, permutations

def genCodes(L):
  return [''.join(code) for code in product('01', repeat=L)]

def phano( codes ):
  if len(set(codes)) != len(codes):
    return False
  for a in codes:
    for b in codes:
      if a != b:
        if a.startswith(b):
          return False
  return True

known = [ '100', '101', '01' ]

Lmax = 4
newCodes = []
for L in range(1,Lmax+1):
  newCodes += genCodes( L )

for c in newCodes[:]:
  if not phano( known+[c] ):
    newCodes.remove( c )

print( newCodes )

minSum = float('inf')

for p in permutations(newCodes, 4):
  if phano( known+list(p) ):
    curSum = sum( len(c) for c in p )
    if curSum < minSum:
      minSum = curSum
      best = list(p)

print( minSum, best )


