from itertools import *

#------------------------------------------
word = 'БЛОКЧЕЙН'
known = {'Б': '1001', 'Л': '00', 'О': '011', 'К': '01010'}
add = 'ЧЕЙН'
#------------------------------------------

def checkPhano( codesDict ):
  codes = list(codesDict.values())
  L = len(codes)
  for i in range(L-1):
    for j in range(i+1,L):
      if codes[i].startswith(codes[j]) or codes[j].startswith(codes[i]):
        raise Exception(f"Условие Фано не выполняется: {codes[i]} {codes[j]}")

checkPhano( known )

def phanoOK( code, known ):
  return all( not c.startswith(code) and not code.startswith(c)
              for c in known.values() )

lenAdd = len(add)
maxL = 4
allCodes = [ ''.join(w) for i in range(1,maxL+1)
             for w in product('01', repeat=i) ]

N = len(allCodes)
minLen = float('inf')
for idx in permutations(range(N), lenAdd):
  curCodes = known.copy()
  for k, i in enumerate(idx):
    if not phanoOK( allCodes[i], curCodes ): break
    curCodes[add[k]] = allCodes[i]
  else:
    curLen = sum( len(curCodes[c]) for c in word )
    if curLen < minLen:
      minLen = curLen
      best = curCodes.copy()

print( minLen, best )