#include <iostream>
#include <bitset>
#include <vector>
#include <set>

unsigned long f(unsigned long N)
{
    // Множество для хранения битов и счетчик их сдвигов (размер 13
    // выбираем т.к. большее число из отрезка 5000 содержит 13 бит)
    std::bitset<13> R(N);
    int shiftCounter = 0;

    // Двигаем влево все биты пока первым слева не окажется 1,
    // попутно запоминая кол-во сдвигов
    for (int i = 13; i > 0; i--)
    {
        if (R[i] == 0 && R[12] != 1)
        {
            shiftCounter++;
            R <<= 1;
        }

        // Если встретилась единица первым битом слева - выход
        // из цикла
        if (R[12] == 1)
            break;
    }

    // Сдвигаем биты еще раз влево чтобы избавиться от первой 1
    R <<= 1;

    // Сдвигаем биты обратно вправо на то же кол-во проделанных сдвигов
    R >>= shiftCounter + 1;

    // Возвращаем результат вычитания
    return N - R.to_ulong();
}

int main()
{
    // Множество разных значений автомата
    std::set<unsigned long> solutionSet;

    // Вставляем значения в множество
    for (int i = 500; i <= 5000; i++)
        solutionSet.insert(f(i));

    // Выводим количество этих значений
    std::cout << "Кол-во значений: " << solutionSet.size() << '\n';
}
