# Михлин Б.С.
'''
8.475 Петя составляет список всех возможных кодов, составленных из заглавных латинских букв.
Сначала он выписывает в алфавитном порядке все коды, состоящие из одного символа (A, B, …, Z),
затем – тоже в алфавитном порядке – коды из двух символов (AA, AB, …, AZ, BA, BB, … ZZ),
далее идут трёхсимвольные коды (AAA, AAB, …, ZZZ) и так далее.
Под каким порядковым номером окажется в этом списке код DEAED? Нумерация начинается с единицы.
'''
# Способ 1. Использование 26-ой системы
# DEAED -> 45154 # числовые эквиваленты букв (должны быть однозначными)
print(int('45154', 26)) # Ответ: 1916594

# Способ 2. Использование функции product
from itertools import *
# Буквы набраны, как они расположены на клавиатуре, а затем сортируются:
# al = ''.join(sorted('QWERTYUIOPASDFGHJKLZXCVBNM'))
al = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ'
n = 0
for k in range(1, 6):
    for x in product(al, repeat=k):
        n += 1
        if ''.join(x) == 'DEAED':
        #if x==tuple('DEAED'):
            print(n) # Ответ: 1916594
            #exit()

