# Михлин Б.С.
'''
8.471 (О. Лысенков) Все девятибуквенные слова, в составе которых могут быть только русские буквы
Т, О, К, С, И, Ч, Н, Ы, Й записаны в алфавитном порядке и пронумерованы начиная с 5.
Вот начало списка:
5.  ИИИИИИИИИ
6.  ИИИИИИИИЙ
7.  ИИИИИИИИК
8.  ИИИИИИИИН
9.  ИИИИИИИИО
10. ИИИИИИИИС
11. ИИИИИИИИТ
12. ИИИИИИИИЧ
13. ИИИИИИИИЫ
14. ИИИИИИИЙИ
...
Под каким номером в этом списке стоит слово ТОКСИЧНЫЙ?
'''
# Способ 1. Использование 9-ичной системы счисления
# Заменим буквы на цифры: и-0, й-1, к-2, н-3, о-4, с-5, т-6, ч-7, ы-8
# Тогда слово 'токсичный' -> 642507381(9)
print(5 + int('642507381', 9)) # Ответ: 278775753

# Способ 2. Использование функции product
from itertools import product
nt = 6 * 9**8 # количество итераций до появления слева (во внешнем цикле) буквы 'т'
n = 4 + nt
for x in product('ийкностчы', repeat=8):
    n += 1
    if ''.join(x) == 'оксичный':
        print(n) # Ответ: 278775753
        break

# Способ 3. Вложенные циклы. Аналогичен способу 2, но медленнее
from sys import exit
nt = 6 * 9**8 # количество итераций до появления во внешнем цикле буквы 'т'
n = 4 + nt
#for a in 'т': # внешний цикл
for b in 'ийкностчы':
  for c in 'ийкностчы':
    for d in 'ийкностчы':
      for e in 'ийкностчы':
        for f in 'ийкностчы':
          for g in 'ийкностчы':
            for h in 'ийкностчы':
              for i in 'ийкностчы':
                n += 1
                x = b + c + d + e + f + g + h + i
                if x == 'оксичный':
                    print(n) # Ответ: 278775753
                    exit()
