def isPrime( n ):
  if n < 2: return False
  if n == 2: return True
  q = round(n**0.5)
  for d in range(2,q+1):
    if n % d == 0: return False
  return True

def allPrimeDivs( n ):
  q = round(n**0.5)
  divs = set()
  for d in range(2,q+1):
    if n % d == 0:
      if isPrime(d): divs.add(d)
      if isPrime(n//d): divs.add(n//d)
  return sorted(divs)

count = 0
results = []
for n in range( 5_123_000+1, 0, -1 ):
  divs = allPrimeDivs(n)
  S = sum(divs)
  if S > 1000000 and S % 1000 == 319:
    results.append( ( n, S ) )
    count += 1
    if count == 5: break

for p in reversed(results):
  print( *p )