def isPrime( n ):
  if n < 2: return False
  if n == 2: return True
  q = round(n**0.5)
  for d in range(2,q+1):
    if n % d == 0: return False
  return True

def allPrimeDivs( n ):
  q = round(n**0.5)
  divs = set()
  for d in range(2,q+1):
    if n % d == 0:
      if isPrime(d): divs.add(d)
      if isPrime(n//d): divs.add(n//d)
  return sorted(divs)

count = 0
for n in range( 3_840_000-1, 0, -1 ):
  divs = allPrimeDivs(n)
  S = sum(divs)
  if S > 1000000 and S % 7 == 0:
    print( n, S )
    count += 1
    if count == 5: break